
data<-read.table("Exp1 data.txt",header=T) #load data file
str(data)


data$subject<-as.factor(data$subject)
data$code<-as.factor(data$code)
data$item<-as.factor(data$item)
data$target_type<-as.factor(data$target_type)
data$length<-as.factor(data$length)
data$occurrence<-as.factor(data$occurrence)
data$pos1<-as.factor(data$pos1)
str(data)


with(data, aggregate(acc=="cor",by=list(subject=subject),mean))->subacc
hist(subacc$x)

subacc$subject[subacc$x<0.56]->under56

subset(data,!subject%in%under56)->data

exceeding<-c("59","60","124")

subset(data,!subject%in%exceeding)->data

table(data$cb)/352

with(data,xtabs(acc=="cor"~length+letter_type)/xtabs(~length+letter_type))


with(data,aggregate(acc=="cor",by=list(letter=letter_type,length=length),mean))->meansExp1

library(lattice)

colors=c("black","lightgrey")
with(meansExp1,barchart(x*100~as.character(length),
     group=letter,type="b",panel=function(...){panel.barchart(...); },
     col=colors,lwd=3,cex=2.5,scales=list(tck=c(1,0), x=list(cex=1.1), y=list(cex=1.7)),key=list(space="right",
     lines=list(col=colors, lty=1, lwd=8),text=list(c("Repeated","Unique")),cex=1.3,title="Letter Type",cex.title=1.6),labels=c("unique","repeated"),
     xlab=list(label="Target Length",cex=1.6,font=2),ylab=list(label="Accuracy (%)",cex=1.4,font=2)))->figexp1


png(file="exp1.png",units="in",width = 7,height = 6,res=300)

plot(figexp1)

dev.off()



library(lme4)
library(phia)


m1<-glmer(acc=="cor"~letter_type*length+(letter_type*length|subject)+(letter_type*length|item),data,family="binomial")# failed to converge

m11<-glmer(acc=="cor"~letter_type*length+(letter_type*length||subject)+(letter_type*length||item),data,family="binomial")# failed to converge; boundary singular fit.

m2<-glmer(acc=="cor"~letter_type*length+(letter_type*length|subject)+(length|item),data,family="binomial") #failed to converge

m2<-glmer(acc=="cor"~letter_type*length+(letter_type*length||subject)+(length||item),data,family="binomial") #failed to converge


###taken from https://github.com/lme4/lme4/issues/98
###for improved optimization

library(nloptr)
defaultControl <- list(algorithm="NLOPT_LN_BOBYQA",xtol_rel=1e-6,maxeval=1e5)
nloptwrap2 <- function(fn,par,lower,upper,control=list(),...) {
    for (n in names(defaultControl)) 
      if (is.null(control[[n]])) control[[n]] <- defaultControl[[n]]
    res <- nloptr(x0=par,eval_f=fn,lb=lower,ub=upper,opts=control,...)
    with(res,list(par=solution,
                  fval=objective,
                  feval=iterations,
                  conv=if (status>0) 0 else status,
                  message=message))
}			


m1_nlopt3<-glmer(acc=="cor"~letter_type*length+(letter_type*length|subject)+(length|item),data,family="binomial",control=glmerControl(optimizer="nloptwrap2")) #Converged.Models with all random slopes failed to converge.


Anova(m1_nlopt3)

testInteractions(m1_nlopt3,fixed="length",pairwise=c("letter_type"),adjustment="none")


#data file for LTRS (Adelman, 2011) simulation

data->datasimall

with(datasimall,aggregate(acc=="cor",by=list(occurrence=occurrence,letter=letter_type,letpair=pos1,length=length),mean))->simmeans


examples<-read.table("stim pair examples.txt")

str(examples)

examples[,c(2,1,3,4)]->examples8
names(examples8)<-c("V1","V2","V3","V4")
examples8$V3<-8
rbind(examples,examples8)->allexamples

cbind(simmeans,allexamples)[,c(1,5,2,3,6,7,4,9)]->exportsimdata
exportsimdata[,5]<-tolower(exportsimdata[,5])
exportsimdata[,6]<-tolower(exportsimdata[,6])

write.table(exportsimdata,"datashortExp12AFC.txt",quote=F,row.names=F,col.names=F)
